############### THUNDERBELT ###############################

def initthunderbelt(char,update=0):
    #combines FFX increase/decrease mass,increased strength,superleaper.
    if isMP():
        return
    if update==0:
        #give him the command to turn the belt on
        Mission_CustomAction('CUSTOM_THUNDERBELTON',char,char,'DynamoPower',5,0)
        FFX_ObjectSetAttr(char,'dynamoOn',0)
        RegTimer('dynamoCheck',1,0,char)
        #load him up with X seconds worth of power, this is set to 1800 or 30 minutes, which is Dynamo's limit, but you can set it for whatever you'd like
        time=1800
        # replace above with "time=randint(minimum time,maximum time)" to define a random coutdown time, i.e. time=randint(180,600) means the time limit will be between 3 and 10 minutes determined when the character is introduced into the map 
        FFX_ObjectSetAttr(char,'dynamoCount',time)
        
def DynamoPower(dummy,char):
    state=FFX_ObjectGetAttr(char,'dynamoOn')
    AI_Animate(char,'special_power_on')
    RegTimer('thunderdial',.7,0,char)
    if state==0:
        #calls atomic shift area effect
        RegTimer('fxDYEnergize',1.4,0,char)
        FFX_ObjectSetAttr(char,'dynamoOn',1)
        energy=Object_GetAttr(char,'energyPoints')
        #energy cost for atomic shift
        Object_SetAttr(char,'energyPoints',energy-25)
        #increase mass
        FFX_MultiplyAttr(char,'mass',5)
        FFX_MultiplyAttr(char,'minForce',5)
        #increase health
        FFX_FactorHealth(char,3)
        FFX_SetStrength(char,4)
        FFX_SetEnergy(char,3)
        FFX_ObjectSetAttr(char,'leapdist',20+Object_GetAttr(char,'baseStrength')*4)
        RegTimer('Dyupdateleaper',1,0,char)
        Mission_RemoveCustomAction('CUSTOM_THUNDERBELTON',char,char)
        Mission_CustomAction('CUSTOM_THUNDERBELTOFF',char,char,'removeDynamoPower',5,0)
        invPoints=FFX_ObjectGetAttr(char,'invPoints')
        #set invulnerability
        if invPoints==0:
            FFX_ObjectSetAttr(char,'ivlastdam',Object_GetAttr(char,'health'))
            RegDamage(char,'OnDyInvulnerableDamage')
            FFX_ObjectSetAttr(char,'invPoints',invPoints+20)
            FFX_ObjectSetAttr(char,'baseInvPoints',invPoints+20)

#play dial turning sound
def thunderdial(event):
    char=event.object
    Sound_PlaySound('fx_thunderbelt_dial',Get_ObjectPos(event.object),1)

#play power off sound
def thunderbeltoff(event):
    char=event.object
    Sound_PlaySound('fx_thunderbelt_off',Get_ObjectPos(event.object),1)

#activates the Thunderbelt's "atomic shift" effect, a low level area effect
def fxDYEnergize(event):
    char=event.object
    Trigger_Explosion(char,'DY Energize',-1)

# if the belt is on - drop the counter, and when it hits zero turn it off completely.
def dynamoCheck(event):
    char=event.object
    #check again in one second
    RegTimer('dynamoCheck',1,0,char)
    #if the belts turned on, decrement the counter
    if FFX_ObjectGetAttr(char,'dynamoOn'):
        count=FFX_ObjectGetAttr(char,'dynamoCount')-1
        FFX_ObjectSetAttr(char,'dynamoCount',count)
        #Warning Buzzer. When time hits X, play alarm effects. It's set to 5 minutes, but change it to whatever time you'd like
        if count==300:
            Object_PlayEffect(char,'effect_ffx_energysparks','',FX_TRACK_OBJECT_POS)
            Sound_PlaySound('fx_thunderbelt_alarm',Get_ObjectPos(event.object),1)
            #and if it hits zero, remove the powers
        if count<=0:
            removeDynamoPower2('',char)
            #this then stops him turning it back on - its spent
            FFX_ObjectSetAttr(char,'dynamoCount',0)
            Mission_RemoveCustomAction('CUSTOM_THUNDERBELTON',char,char)
            ep=Object_GetAttr(char,'energyPoints')
            #if energy is all gone, KO character from exhaustion
            if ep<=0:     
                if Object_IsAlive(char):
                    cshelper.kill(char)
                    FFX_ApplyDamage(char,5)

#character turns off belt
def removeDynamoPower(dummy,char):
    AI_Animate(char,'special_power_off')
    RegTimer('thunderdial',.5,0,char)
    RegTimer('thunderdial',1,0,char)
    state=FFX_ObjectGetAttr(char,'dynamoOn')
    Object_PlayEffect(char,'effect_ffx_density','',FX_TRACK_OBJECT_POS)
    RegTimer('thunderbeltoff',1.2,0,char)
    if state==1:
        FFX_ObjectSetAttr(char,'dynamoOn',0)
        FFX_MultiplyAttr(char,'mass',0.2)
        FFX_MultiplyAttr(char,'minForce',0.2)
        FFX_SetStrength(char,0)
        FFX_FactorHealth(char,0.334)
        FFX_ObjectSetAttr(char,'leapdist',0+Object_GetAttr(char,'baseStrength')*0)
        RegTimer('Dyupdateleaperoff',1,0,char)
        Mission_CustomAction('CUSTOM_THUNDERBELTON',char,char,'DynamoPower',5,0)
        Mission_RemoveCustomAction('CUSTOM_THUNDERBELTOFF',char,char)
        removeCommand('CUSTOM_MIGHTYLEAP',char)
        invPoints=FFX_ObjectGetAttr(char,'invPoints')
        if invPoints>0:
            FFX_ObjectSetAttr(char,'ivlastdam',Object_GetAttr(char,'health'))
            RegDamage(char,'OnDyInvulnerableDamage')
        FFX_ObjectSetAttr(char,'invPoints',invPoints-20)
        FFX_ObjectSetAttr(char,'baseInvPoints',invPoints-20)

#belt automatically shuts off
def removeDynamoPower2(dummy,char):
    state=FFX_ObjectGetAttr(char,'dynamoOn')
    Object_PlayEffect(char,'effect_ffx_density','',FX_TRACK_OBJECT_POS)
    RegTimer('thunderbeltoff',.3,0,char)
    if state==1:
        FFX_ObjectSetAttr(char,'dynamoOn',0)
        FFX_MultiplyAttr(char,'mass',0.2)
        FFX_MultiplyAttr(char,'minForce',0.2)
        FFX_SetStrength(char,0)
        FFX_FactorHealth(char,0.334)
        FFX_ObjectSetAttr(char,'leapdist',0+Object_GetAttr(char,'baseStrength')*0)
        RegTimer('Dyupdateleaperoff',1,0,char)
        Mission_RemoveCustomAction('CUSTOM_THUNDERBELTON',char,char)
        Mission_RemoveCustomAction('CUSTOM_THUNDERBELTOFF',char,char)
        removeCommand('CUSTOM_MIGHTYLEAP',char)
        invPoints=FFX_ObjectGetAttr(char,'invPoints')
        if invPoints>0:
            FFX_ObjectSetAttr(char,'ivlastdam',Object_GetAttr(char,'health'))
            RegDamage(char,'OnDyInvulnerableDamage')
        FFX_ObjectSetAttr(char,'invPoints',invPoints-20)
        FFX_ObjectSetAttr(char,'baseInvPoints',invPoints-20)        

def Dyupdateleaper(event):
    char=event.object
    update=event.user
    radius=FFX_ObjectGetAttr(char,'leapdist',30)
    addCommand('CUSTOM_MIGHTYLEAP',char,'OnDyLeapTo',radius,update)

def Dyupdateleaperoff(event):
    char=event.object
    removeCommand('CUSTOM_MIGHTYLEAP',char)

def OnDyLeapTo(target,char):
    pos=GetTargetPos(char,target)
    FFX_TP(char,(pos[0],pos[1],500),'FFR_TP2DY',0)

def OnDyInvulnerableDamage(event):
    char=event.object
    RegDamage(char,'OnDyInvulnerableDamage')
    if Object_IsAlive(char):
        health=Object_GetAttr(char,'health')
        damage=FFX_ObjectGetAttr(char,'ivlastdam',health)-health
        if damage>0:
            payback=FFX_ObjectGetAttr(char,'invPoints')
            if payback>damage:
                payback=damage
            Object_SetAttr(char,'health',health+payback)
            FFX_ObjectSetAttr(char,'ivlastdam',health+payback)
            
#controls energy cost and impact/recoil effect for Mighty Leap 
def FFR_TP2DY(event):
    char=event.object
#    print 'ffx_tp2:char=%s'%(char)
    Object_SetAttr(char,'strength',FFX_ObjectGetAttr(char,'jumpStrength'))
    Object_SetAttr(char,'speed',FFX_ObjectGetAttr(char,'jumpSpeed'))
    energy=Object_GetAttr(char,'energyPoints')
    #energy cost
    Object_SetAttr(char,'energyPoints',energy-50)
    pos=Get_ObjectPos(char)
    FFX_ObjectSetAttr(char,'lastY',pos[1])
    FFX_ObjectSetAttr(char,'lastX',pos[0])
    # you'll need to manually add character name and "DY impact" to heavyfooted in ffxcustom.py
    Trigger_Explosion(char,getByTemplate(char,FFX_HEAVYFOOTED_CUSTOM,1))
            

